<%@ LANGUAGE="VBScript" %>

<% '***************************************************************************
   '* ASP Football Pool                                                       *
   '*                                                                         *
   '* Copyright 2000 by Mike Hall                                             *
   '* Please see http://www.brainjar.com for documentation and terms of use.  *
   '***************************************************************************
%>

<!-- #include file="protect.inc" -->
<!-- #include file="common.inc" -->
<!-- #include file="header.inc" -->

<% 'Tie breaker constants.

   Const TIE_BREAKER_DEBUG_ON = false
   Const TIE_BREAKER_MIN_WEEK = 6

   'Set up conference and division names.

   conferences = Array("AFC", "NFC")
   divisions   = Array("East", "Central", "West")

   'Open the database.

   call OpenDB()

   'Get list of teams and data ordered by conference, division and name.

   dim teams
   n = NumberOfTeams()
   redim teams(n - 1)

   i = 0
   sql = "select * from Teams order by Conference, Division, City, Name"
   set rs = DbConn.Execute(sql)
   if not (rs.BOF and rs.EOF) then
     do while not rs.EOF
       set teams(i) = new TeamObj
       teams(i).setData(rs.Fields("TeamID").Value)
       i = i + 1
       rs.MoveNext
     loop
   end if

   'Sort teams within each division.

   div = teams(0).division
   m = 0
   for i = 0 to UBound(teams)
     if teams(i).division <> div then
       call SortTeams(m, i - 1)
       div = teams(i).division
       m = i
     end if
   next
   call SortTeams(m, i - 1) %>

<p><table class="formatted" cellpadding=0 cellspacing=0>
<% div = 0
   for i = 0 to UBound(teams)
     if div <> teams(i).division then
       n = 0
       div = teams(i).division
       if teams(i).conference = 1 then
         styleClass = "afc"
       else
         styleClass = "nfc"
       end if %>
<tr align=right>
  <th align=left class="<% = styleClass %>"><% = conferences(teams(i).conference - 1) & " " & divisions(div - 1) %></th>
  <th class="<% = styleClass %>">W</th>
  <th class="<% = styleClass %>">L</th>
  <th class="<% = styleClass %>">T</th>
  <th class="<% = styleClass %>">Pct</th>
  <th class="<% = styleClass %>">PF</th>
  <th class="<% = styleClass %>">PA</th>
  <th class="<% = styleClass %>">Home</th>
  <th class="<% = styleClass %>">Road</th>
  <th class="<% = styleClass %>">AFC</th>
  <th class="<% = styleClass %>">NFC</th>
  <th class="<% = styleClass %>">Div</th>
  <th class="<% = styleClass %>">Strk</th>
</tr>
<%   end if
     if Round(i / 2) * 2 = i then %>
<tr align=right>
<%   else %>
<tr align=right class="alt">
<%   end if %>
  <td align=left>
  <b><a href="team.asp?id=<% = teams(i).id %>"><% = teams(i).name %></a></b>
  </td>
  <td>&nbsp;<% = teams(i).totalWins %></td>
  <td>&nbsp;<% = teams(i).totalLosses %></td>
  <td>&nbsp;<% = teams(i).totalTies %></td>
  <td>&nbsp;<% = FormatNumber(teams(i).totalPct, 3) %></td>
  <td>&nbsp;<% = teams(i).pointsFor %></td>
  <td>&nbsp;<% = teams(i).PointsAgainst %></td>
  <td>&nbsp;<% = FormatRecord(teams(i).homeWins, teams(i).homeLosses, teams(i).homeTies) %></td>
  <td>&nbsp;<% = FormatRecord(teams(i).roadWins, teams(i).roadLosses, teams(i).roadTies) %></td>
  <td>&nbsp;<% = FormatRecord(teams(i).afcWins, teams(i).afcLosses, teams(i).afcTies) %></td>
  <td>&nbsp;<% = FormatRecord(teams(i).nfcWins, teams(i).nfcLosses, teams(i).nfcTies) %></td>
  <td>&nbsp;<% = FormatRecord(teams(i).divWins, teams(i).divLosses, teams(i).divTies) %></td>
  <td>&nbsp;<% = teams(i).streak %></td>
</tr>
<%   'Output debug information for testing tie breaker results.

     if TIE_BREAKER_DEBUG_ON and teams(i).tb <> "" then
       if Round(i / 2) * 2 = i then %>
<tr align=right>
<%     else %>
<tr align=right class="alt">
<%     end if %>
  <td align=left colspan=13><font face="MS Sans Serif,Arial,Helvetica" size=1>
  Note: <% = teams(i).tb %>
  </td>
</tr>
<%   end if
   next %>
</table></p>

<!-- #include file="footer.inc" -->

<% '***************************************************************************
   '* Local functions and subroutines.                                              *
   '***************************************************************************

   '---------------------------------------------------------------------------
   ' NumberOfTeams(): Returns the total number of teams in the database.
   '---------------------------------------------------------------------------

   function NumberOfTeams()

     dim sql, rs

     NumberOfTeams = 0
     sql = "select count(TeamID) as total from Teams"
     set rs = DbConn.Execute(sql)
     if not (rs.BOF and rs.EOF) then
       NumberOfTeams = rs.Fields("total").Value
     end if

   end function

   '---------------------------------------------------------------------------
   ' FormatRecord(w, l, t): Formas a win-loss-tie record for output. Ties are
   ' not displayed if they are equal to zero.
   '---------------------------------------------------------------------------

   function FormatRecord(w, l, t)

     FormatRecord = w & "-" & l
     if t > 0 then
       FormatRecord = FormatRecord & "-" & t
     end if

   end function

   '---------------------------------------------------------------------------
   ' SortTeams(first, last): Used on the global team object array to sort the
   ' items within the given range based on team records and tie-breakers (where
   ' applicable). See individual tie-breaker subroutines below.
   '---------------------------------------------------------------------------

   sub SortTeams(first, last)

     dim i, j, tmp
     dim n, same, tie

     if last <= first then
       exit sub
     end if

     'Sort based on overall record.

     for i = first to last - 1
       for j = i + 1 to last
         if teams(j).totalPct > teams(i).totalPct then
           set tmp = teams(i)
           set teams(i) = teams(j)
           set teams(j) = tmp
         end if
       next
     next

     'Apply tie breakers to any teams with the same record (but only when the
     'minimal week has been reached.

     if CurrentWeek() >= TIE_BREAKER_MIN_WEEK then
       for i = first to last - 1
         same = true
         tie = false
         n = teams(i).totalPct
         j = i + 1
         do while (j <= last and same)
           if teams(j).totalPct = n then
             tie = true
             j = j + 1
           else
             same = false
           end if
         loop
         if tie then
           call ApplyTiebreaker1(i, j - 1)
         end if
       next
     end if

   end sub

   '---------------------------------------------------------------------------
   ' Divisional Tiebreaker #1: Best head-to-head record.
   '---------------------------------------------------------------------------

   sub ApplyTieBreaker1(first, last)

     dim n1, n2
     dim i, j
     dim w, l, t

     'Two teams, head-to-head.

     if last - first = 1 then
       n1 = CountMatches(teams(first).oppWonAgainst, teams(last).id)
       n2 = CountMatches(teams(last).oppWonAgainst, teams(first).id)
       if n1 <> n2 then
         if n2 > n1 then
           set tmp = teams(first)
           set teams(first) = teams(last)
           set teams(last) = tmp
         end if
         teams(first).tb = "Beat " & teams(last).name & " head-to-head."
         teams(last).tb = ""
       else
         call ApplyTiebreaker2(first, last)
       end if

     'Three or more teams, head-to-head.

     else
       for i = first to last
         w = 0
         l = 0
         t = 0
         for j = first to last
           if i <> j then
             w = w + CountMatches(teams(i).oppWonAgainst, teams(j).id)
             l = l + CountMatches(teams(i).oppLostTo, teams(j).id)
             t = t + CountMatches(teams(i).oppTiedWith, teams(j).id)
           end if
           if w = 0 and l = 0 and t = 0 then
             call ApplyTiebreaker2(first, last)
           end if
         next
         teams(i).tb = CalcPct(w, l, t)
       next
       call SortByTB(first, last)
       if teams(first).tb > teams(first + 1).tb then
         call ApplyTiebreaker1(first + 1, last)
         teams(first).tb = "Better head-to-head record against "
         for i = first + 1 to last
           teams(first).tb = teams(first).tb & teams(i).name & ", "
           teams(i).tb = ""
         next
         teams(first).tb = Left(teams(first).tb, Len(teams(first).tb) - 2) & "."
       elseif teams(first).tb = teams(first + 1).tb and _
              teams(first).tb > teams(first + 2).tb then
         call ApplyTiebreaker1(first, first + 1)
         call ApplyTiebreaker1(first + 2, last)
       else
         call ApplyTiebreaker2(first, last)
       end if

     end if

   end sub  

   '---------------------------------------------------------------------------
   ' Divisional Tiebreaker #2: Best record in division.
   '---------------------------------------------------------------------------

   sub ApplyTieBreaker2(first, last)

     dim n1, n2
     dim i, j
     dim w, l, t

     'Two teams, division records.

     if last - first = 1 then
       n1 = teams(first).divPct
       n2 = teams(last).divPct
       if n1 <> n2 then
         if n2 > n1 then
           set tmp = teams(first)
           set teams(first) = teams(last)
           set teams(last) = tmp
         end if
         teams(first).tb = "Better division record than " & teams(last).name & "."
         teams(last).tb = ""
       else
          call ApplyTiebreaker3(first, last)
       end if

     'Three or more teams, division records.

     else
       for i = first to last
         teams(i).tb = teams(i).divPct
       next
       call SortByTB(first, last)
       if teams(first).tb > teams(first + 1).tb then
         call ApplyTiebreaker1(first + 1, last)
         teams(first).tb = "Better division record than "
         for i = first + 1 to last
           teams(first).tb = teams(first).tb & teams(i).name & ", "
           teams(i).tb = ""
         next
         teams(first).tb = Left(teams(first).tb, Len(teams(first).tb) - 2) & "."
       elseif teams(first).tb = teams(first + 1).tb and _
              teams(first).tb > teams(first + 2).tb then
         call ApplyTiebreaker1(first, first + 1)
         call ApplyTiebreaker1(first + 2, last)
       else
         call ApplyTiebreaker3(first, last)
       end if

     end if

   end sub  

   '---------------------------------------------------------------------------
   ' Divisional Tiebreaker #3: Best record in conference.
   '---------------------------------------------------------------------------

   sub ApplyTieBreaker3(first, last)

     dim n1, n2
     dim i, j
     dim conf

     'Determine conference.

     if teams(first).conference = 1 then
       conf = "afc"
     else
       conf = "nfc"
     end if

     'Two teams, conference records.

     if last - first = 1 then
       n1 = teams(first).confPct
       n2 = teams(last).confPct
       if n1 <> n2 then
         if n2 > n1 then
           set tmp = teams(first)
           set teams(first) = teams(last)
           set teams(last) = tmp
         end if
         teams(first).tb = "Better conference record than " & teams(last).name & "."
         teams(last).tb = ""
       else
         call ApplyTiebreaker4(first, last)
       end if

     'Three or more teams, conference records.

     else
       for i = first to last
         teams(i).tb = teams(i).confPct
       next
       call SortByTB(first, last)
       if teams(first).tb > teams(first + 1).tb then
         call ApplyTiebreaker1(first + 1, last)
         teams(first).tb = "better conference record than "
         for i = first + 1 to last
           teams(first).tb = teams(first).tb & teams(i).name & ", "
           teams(i).tb = ""
         next
         teams(first).tb = Left(teams(first).tb, Len(teams(first).tb) - 2) & "."
       elseif teams(first).tb = teams(first + 1).tb and _
              teams(first).tb > teams(first + 2).tb then
         call ApplyTiebreaker1(first, first + 1)
         call ApplyTiebreaker1(first + 2, last)
       else
         call ApplyTiebreaker4(first, last)
       end if

     end if

   end sub  

   '---------------------------------------------------------------------------
   ' Divisional Tiebreaker #4: Best record in common games.
   '---------------------------------------------------------------------------

   sub ApplyTieBreaker4(first, last)

     dim i, j
     dim list, c
     dim w, l, t

     'Find common games.

     list = ""
     for i = 0 to UBound(teams)
       found = true
       for j = first to last
         c = CountMatches(teams(j).oppWonAgainst, teams(i).id) _
           + CountMatches(teams(j).oppLostTo, teams(i).id) _
           + CountMatches(teams(j).oppTiedWith, teams(i).id)
         if c = 0 then
           found = false
         end if
       next
       if found then
         if list = "" then
           list = teams(i).id
         else
           list = list & "," & teams(i).id
         end if
       end if
     next
     list = Split(list, ",")

     'Get winning percentage in common games.

     for i = first to last
       w = 0
       l = 0
       t = 0
       for j = 0 to UBound(list)
         w = w + CountMatches(teams(i).oppWonAgainst, list(j))
         l = l + CountMatches(teams(i).oppLostTo, list(j))
         t = t + CountMatches(teams(i).oppTiedWith, list(j))
       next
       teams(i).tb = CalcPct(w, l, t)
     next
     call SortByTB(first, last)

     'Two teams, common games.

     if last - first = 1 then
       if teams(first).tb > teams(last).tb then
         teams(first).tb = "Better record in common games than " & teams(last).name & "."
         teams(last).tb = ""
       else
         call ApplyTiebreaker5(first, last)
       end if

     'Three or more teams, common games.

     else
       if teams(first).tb > teams(first + 1).tb then
         call ApplyTiebreaker1(first + 1, last)
         teams(first).tb = "Better record in common games than "
         for i = first + 1 to last
           teams(first).tb = teams(first).tb & teams(i).name & ", "
           teams(i).tb = ""
         next
         teams(first).tb = Left(teams(first).tb, Len(teams(first).tb) - 2) & "."
       elseif teams(first).tb = teams(first + 1).tb and _
              teams(first).tb > teams(first + 2).tb then
         call ApplyTiebreaker1(first, first + 1)
         call ApplyTiebreaker1(first + 2, last)
       else
         call ApplyTiebreaker5(first, last)
       end if

     end if

   end sub  

   '---------------------------------------------------------------------------
   ' Divisional Tiebreaker #5: Net points in division games.
   '---------------------------------------------------------------------------

   sub ApplyTieBreaker5(first, last)

     dim i, j

     'Sort teams by net points in division games.

     for i = first to last
       teams(i).tb = teams(i).netDivPoints
     next
     call SortByTB(first, last)

     'Two teams, net points in division games.

     if last - first = 1 then
       if teams(first).tb > teams(last).tb then
         teams(first).tb = "More net points in division games than " & teams(last).name & "."
         teams(last).tb = ""
       else
         call ApplyTiebreaker6(first, last)
       end if

     'Three or more teams, net points in division games.

     else
       if teams(first).tb > teams(first + 1).tb then
         call ApplyTiebreaker1(first + 1, last)
         teams(first).tb = "More net points in division games than "
         for i = first + 1 to last
           teams(first).tb = teams(first).tb & teams(i).name & ", "
           teams(i).tb = ""
         next
         teams(first).tb = Left(teams(first).tb, Len(teams(first).tb) - 2) & "."
       elseif teams(first).tb = teams(first + 1).tb and _
              teams(first).tb > teams(first + 2).tb then
         call ApplyTiebreaker1(first, first + 1)
         call ApplyTiebreaker1(first + 2, last)
       else
         call ApplyTiebreaker6(first, last)
       end if

     end if

   end sub  

   '---------------------------------------------------------------------------
   ' Divisional Tiebreaker #6: Net points in all games.
   '---------------------------------------------------------------------------

   sub ApplyTieBreaker6(first, last)

     dim i, j

     'Sort teams by net points in all games.

     for i = first to last
       teams(i).tb = teams(i).pointsFor - teams(i).pointsAgainst
     next
     call SortByTB(first, last)

     'Two teams, net points in all games.

     if last - first = 1 then
       if teams(first).tb > teams(last).tb then
         teams(first).tb = "More net points in all games than " & teams(last).name & "."
         teams(last).tb = ""
       else
         call ApplyTiebreaker7(first, last)
       end if

     'Three or more teams, net points in all games.

     else
       if teams(first).tb > teams(first + 1).tb then
         call ApplyTiebreaker1(first + 1, last)
         teams(first).tb = "More net points in all games than "
         for i = first + 1 to last
           teams(first).tb = teams(first).tb & teams(i).name & ", "
           teams(i).tb = ""
         next
         teams(first).tb = Left(teams(first).tb, Len(teams(first).tb) - 2) & "."
       elseif teams(first).tb = teams(first + 1).tb and _
              teams(first).tb > teams(first + 2).tb then
         call ApplyTiebreaker1(first, first + 1)
         call ApplyTiebreaker1(first + 2, last)
       else
         call ApplyTiebreaker7(first, last)
       end if

     end if

   end sub  

   '---------------------------------------------------------------------------
   ' Divisional Tiebreaker #7: Strength of schedule.
   '---------------------------------------------------------------------------

   sub ApplyTieBreaker7(first, last)

     dim i, j
     dim id
     dim w, l, t

     'Sort teams by opponents winning percentage.

     for i = first to last
       w = 0
       l = 0
       t = 0
       for each id in teams(i).allOpponents
         for j = 0 to UBound(teams)
           if teams(j).id = id then
             w = w + teams(j).totalWins
             l = l + teams(j).totalLosses
             t = t + teams(j).totalTies
           end if
         next
       next
       teams(i).tb = CalcPct(w, l, t)
     next
     call SortByTB(first, last)

     'Two teams, strength of schedule.

     if last - first = 1 then
       if teams(first).tb > teams(last).tb then
         teams(first).tb = "Strength of schedule better than " & teams(last).name & "."
         teams(last).tb = ""
       else
         teams(first).tb = "Unable to determine tie breaker"
         teams(last).tb = ""
       end if

     'Three or more teams, strength of schedule.

     else
       if teams(first).tb > teams(first + 1).tb then
         call ApplyTiebreaker1(first + 1, last)
         teams(first).tb = "Strength of schedule better than "
         for i = first + 1 to last
           teams(first).tb = teams(first).tb & teams(i).name & ", "
           teams(i).tb = ""
         next
         teams(first).tb = Left(teams(first).tb, Len(teams(first).tb) - 2) & "."
       elseif teams(first).tb = teams(first + 1).tb and _
              teams(first).tb > teams(first + 2).tb then
         call ApplyTiebreaker1(first, first + 1)
         call ApplyTiebreaker1(first + 2, last)
       else
         teams(first).tb = "Unable to determine tiebreaker."
         for i = first + 1 to last
           teams(i).tb = ""
         next
       end if

     end if

   end sub  

   '---------------------------------------------------------------------------
   ' SortByTB(first, last): Sorts the global list of teams within the given
   ' range based on whatever value is currently in their tie-breaker fields.
   '---------------------------------------------------------------------------

   sub SortByTB(first, last)

     dim i, j, tmp

     if last <= first then
       exit sub
     end if

     for i = first to last - 1
       for j = i + 1 to last
         if teams(j).tb > teams(i).tb then
           set tmp = teams(i)
           set teams(i) = teams(j)
           set teams(j) = tmp
         end if
       next
     next

   end sub

   '---------------------------------------------------------------------------
   ' CalcPct(w, l, t): Calculates a winning percentage given a number of wins,
   ' losses and ties.
   '---------------------------------------------------------------------------

   function CalcPct(w, l, t)

     dim n

     CalcPct = 0
     n = w + l + t
     if n > 0 then
       CalcPct = (w + t / 2) / n
     end if

   end function

   '---------------------------------------------------------------------------
   ' CountMatches(list, x): Returns the number of occurences of value 'x' in
   ' array 'list'.
   '---------------------------------------------------------------------------

   function CountMatches(list, x)

     dim i

     CountMatches = 0
     for i = 0 to UBound(list)
       if list(i) = x then
         CountMatches = CountMatches + 1
       end if
     next

   end function

   '***************************************************************************
   '* Local class definitions.                                                      *
   '***************************************************************************

   '---------------------------------------------------------------------------
   ' TeamObj(id): Used to hold data for a single team.
   '---------------------------------------------------------------------------

   Class TeamObj

     public id, name, division, conference

     public totalWins, totalLosses, totalTies
     public homeWins,  homeLosses,  homeTies
     public roadWins,  roadLosses,  roadTies
     public afcWins,   afcLosses,   afcTies
     public nfcWins,   nfcLosses,   nfcTies
     public confWins,  confLosses,  confTies
     public divWins,   divLosses,   divTies

     public totalPct, confPct, divPct

     public streak

     public pointsFor, pointsAgainst, netDivPoints

     public allOpponents
     public oppWonAgainst, oppLostTo, oppTiedWith

     public tb

     private sub Class_Initialize()

       totalWins = 0 : totalLosses = 0 : totalTies = 0
       homeWins  = 0 : homeLosses  = 0 : homeTies  = 0
       roadWins  = 0 : roadLosses  = 0 : roadTies  = 0
       afcWins   = 0 : afcLosses   = 0 : afcTies   = 0
       nfcWins   = 0 : nfcLosses   = 0 : nfcTies   = 0
       divWins   = 0 : divLosses   = 0 : divTies   = 0

       totalPct = 0 : confPct  = 0 : divPct   = 0

       streak = ""

       pointsFor = 0 : pointsAgainst = 0 : netDivPoints = 0

       allOpponents  = Array()
       oppWonAgainst = Array() : oppLostTo = Array() : oppTiedWith = Array()

       tb = ""

     end sub

     private sub Class_Terminate()
     end sub

     public sub setData(teamID)

       dim sql, rs
       dim opponentID
       dim tempID, inList
       dim currentStreak

       id = teamID

       'Get team conference, division and display name.

       sql = "select * from Teams where TeamID = '" & teamID & "'"
       set rs = DbConn.Execute(sql)
       if not (rs.BOF and rs.EOF) then
         conference = rs.Fields("Conference").Value
         division = rs.Fields("Division").Value
         if rs.Fields("DisplayName") <> "" then
           name = rs.Fields("DisplayName").Value
         else
           name = rs.Fields("City").Value
         end if
       end if

       'Find records and point totals for all games played by this team.

       sql = "select * from Teams, Schedule" _
          & " where Result <> ''" _
          & " and" _
          & " ((VisitorID = '" & teamID & "' and TeamID = HomeID)" _
          & "  or" _
          & "  (HomeID    = '" & teamID & "' and TeamID = VisitorID))" _
          & " order by Schedule.Week"
       set rs = DbConn.Execute(sql)
       if not (rs.BOF and rs.EOF) then
         currentStreak = ""
         do while not rs.EOF

           'Get opponent team id and add to team's opponents list if not
           'already added.

           if rs.Fields("HomeID").Value = teamID then
             opponentID = rs.Fields("VisitorID").Value
           else
             opponentID = rs.Fields("HomeID").Value
           end if
           inList = false
           for each tempID in allOpponents
             if tempID = opponentID then
               inList = true
             end if
           next
           if not inList then
             redim preserve allOpponents(Ubound(allOpponents) + 1)
             allOpponents(Ubound(allOpponents)) = opponentID
           end if

           'Record a win.

           if rs.Fields("Result").Value = teamID then
             totalWins = totalWins + 1
             if currentStreak <> "W" then
               currentStreak = "W"
               streak = 1
             else
               streak = streak + 1
             end if
             if rs.Fields("HomeID").Value = teamID then
               homeWins = homeWins + 1
             else
               roadWins = roadWins + 1
             end if
             if rs.Fields("Conference").Value = 1 then
               afcWins = afcWins + 1
             else
               nfcWins = nfcWins + 1
             end if
             if rs.Fields("Conference").Value = conference and _
                rs.Fields("Division").Value = division then
               divWins = divWins + 1
             end if

           'Record a loss.

           elseif rs.Fields("Result").Value = opponentID then
             totalLosses = totalLosses + 1
             if currentStreak <> "L" then
               currentStreak = "L"
               streak = 1
             else
               streak = streak + 1
             end if
             if rs.Fields("HomeID").Value = teamID then
               homeLosses = homeLosses + 1
             else
               roadLosses = roadLosses + 1
             end if
             if rs.Fields("Conference").Value = 1 then
               afcLosses = afcLosses + 1
             else
               nfcLosses = nfcLosses + 1
             end if
             if rs.Fields("Conference").Value = conference and _
                rs.Fields("Division").Value = division then
               divLosses = divLosses + 1
             end if

           'Record a tie.

           else
             if currentStreak <> "T" then
               currentStreak = "T"
               streak = 1
             else
               streak = streak + 1
             end if
             if rs.Fields("HomeID").Value = teamID then
               homeTies= homeTies + 1
             else
               roadTies = roadTies + 1
             end if
             if rs.Fields.conference.Value = 1 then
               afcTies = afcTies + 1
             else
               nfcTies = nfcTies + 1
             end if
             if rs.Fields.conference.Value = conference and _
                rs.Fields("Division").Value = division then
               divTies = divTies + 1
             end if
           end if

           'Add scores to point totals.

           if rs.Fields("VisitorID").Value = teamID then
             pointsFor = pointsFor + rs.Fields("VisitorScore").Value
             pointsAgainst = pointsAgainst + rs.Fields("HomeScore").Value
             if rs.Fields("Division").Value = division then
               netDivPoints = netDivPoints + rs.Fields("VisitorScore").Value - rs.Fields("HomeScore").Value
             end if
           else
             pointsFor = pointsFor + rs.Fields("HomeScore").Value
             pointsAgainst = pointsAgainst + rs.Fields("VisitorScore").Value
             if rs.Fields("Division").Value = division then
               netDivPoints = netDivPoints + rs.Fields("HomeScore").Value - rs.Fields("VisitorScore").Value
             end if
           end if

           'Add opponent to proper W-L-T list (may be added more than once).

           if currentStreak = "W" then
             redim preserve oppWonAgainst(Ubound(oppWonAgainst) + 1)
             oppWonAgainst(Ubound(oppWonAgainst)) = opponentID
           elseif currentStreak = "L" then
             redim preserve oppLostTo(Ubound(oppLostTo) + 1)
             oppLostTo(Ubound(oppLostTo)) = opponentID
           elseif currentStreak = "T" then
             redim preserve oppTiedWith(Ubound(oppTiedWith) + 1)
             oppTiedWith(Ubound(oppTiedWith)) = opponentID
           end if

           rs.MoveNext
         loop
       end if

       if conference = 1 then
         confWins = afcWins
         confLosses = afcLosses
         confTies = afcTies
       else
         confWins = nfcWins
         confLosses = nfcLosses
         confTies = nfcTies
       end if

       'Set streak.

       streak = currentStreak & streak

       'Set win-loss-tie percentages.

       totalPct = CalcPct(totalWins, totalLosses, totalTies)
       confPct  = CalcPct(confWins,  confLosses,  confTies)
       divPct   = CalcPct(divWins,   divLosses,   divTies)

     end sub

   end class %>
